<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InterviewAnswer extends Model
{
    use HasFactory;

    protected $table = 'interview_answers';
    protected $primaryKey = 'Interview_answer_id';
    public $incrementing = true;

    // Define custom timestamp columns
    const CREATED_AT = 'Created_at';
    const UPDATED_AT = 'Updated_at';

    protected $fillable = [
        'Interview_id',
        'Question_id',
        'Answer_text',
        'Score',
        'Feedback',
    ];

    protected $casts = [
        'Score' => 'decimal:2',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function interview()
    {
        return $this->belongsTo(InterviewAttempt::class, 'Interview_id', 'Interview_id');
    }

    public function question()
    {
        return $this->belongsTo(InterviewQuestion::class, 'Question_id', 'Interview_question_id');
    }
}
